%\usepackage{showframe}
%\renewcommand*\ShowFrameColor{\color{red}}

\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
%\usepackage{times}
%\usepackage{newtxtext}
\usepackage{mathptmx}
\usepackage[english,french,spanish,italian]{babel}
\usepackage{amsfonts}
\usepackage{amsmath}
\usepackage{amssymb}
\usepackage{bm}
\usepackage{pifont}
\usepackage{xcolor}

\usepackage{hyperref}
 
\usepackage{graphicx}
\usepackage{tabularx}
\usepackage{caption}
\usepackage{multirow}
\usepackage{multicol}


\usepackage[round,sort]{natbib} 

\bibliographystyle{apalike}     


\usepackage{geometry}
\geometry{
  textheight=241mm,
  textwidth=160mm,   
  left=25mm,
  right=25mm,
  top=31mm,
  bottom=25mm,
  head=23mm,
  foot=15mm,
  headsep=12pt,
  footskip=30pt
}
\usepackage{setspace}

%\usepackage{microtype}
%\SetTracking[ spacing = {25*,166, } ]{ encoding = *, shape = sc }{ 25 }

\makeatletter
\def\@maketitle{%
\newpage%
\null%
\vskip 2em % <=== BEFORE THE TITLE
\begin{center}%
    \let\footnote\thanks %
    {\@title %
      \par %
    }
\vskip 2.5em % <=== AFTER THE TITLE
    {\large
    \lineskip .5em
    \begin{tabular}[t]{c}
       \baselineskip=14pt
       \@author
    \end{tabular}
    \par%
    }
%   \vskip 1em
    {
    \large
    \@date
    }
\end{center}
\par %
\vskip 2.5em} 
% <=== BEFORE THE ABSTRACT
\makeatother

\usepackage{authblk}
\renewcommand\Authfont{\normalfont\fontsize{14}{16.8}}
\renewcommand\Affilfont{\normalfont\fontsize{12}{14.4}}
\renewcommand\Authsep{, }
\renewcommand\Authand{, }
\renewcommand\Authands{, }
\setlength{\affilsep}{12pt}

\usepackage{fancyhdr}


\pagestyle{fancy}

\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0.5pt}
\renewcommand{\footruleskip}{2pt}

\fancyhf{} % pulisce tutto

\fancyhead[RO,LE]{\footnotesize{\thepage}}
\fancyfoot[C]{\small\color{gray} JADT 2026: 18th International Conference on Statistical Analysis of Textual Data}

\fancypagestyle{plain}{
  \fancyhf{}
  \fancyfoot[C]{\small\color{gray} JADT 2026: 18th International Conference on Statistical Analysis of Textual Data}
  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0.5pt}
}

\usepackage[bottom,hang]{footmisc}
\setlength{\footnotemargin}{6pt}
\renewcommand\footnoterule{\vspace*{5mm} \hrule width 50mm height .5pt \vspace*{5mm}}


\makeatletter
\setcounter{secnumdepth}{3}
\renewcommand*{\@seccntformat}[1]{\csname the#1\endcsname~}
\renewcommand\thesection{\@arabic\c@section.}
\renewcommand\thesubsection{\thesection\@arabic\c@subsection.}
\renewcommand\thesubsubsection{\thesubsection\@arabic\c@subsubsection.}

\renewcommand{\abstract}{\@startsection{abstract}{4}{\z@}%
{22pt \@plus 0pt \@minus 0pt}%
{4pt \@plus 0pt}%
{\centering\normalfont\fontsize{14}{16.8}\bfseries}}
\renewcommand\section{\@startsection{section}{1}{\z@}%
  {6pt \@plus 0pt \@minus 0pt}%
  {6pt \@plus 0pt}%
  {\normalfont\fontsize{14}{16.8}\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
  {3pt \@plus 0pt \@minus 0pt}%
  {3pt \@plus 0pt}%
  {\normalfont\fontsize{12}{14.4}\bfseries\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {3pt \@plus 0pt \@minus 0pt}%
  {3pt \@plus 0pt}%
  {\normalfont\fontsize{12}{14.4}\itshape}}

\renewcommand\@biblabel[1]{}
\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{}%
           {\small
           \leftmargin0pt
            \@openbib@code
            \usecounter{enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newcommand{\quotemark}[1]{``{#1}''}